SET QUOTED_IDENTIFIER ON
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 155
      AND SKL.[COMMENT] = '005 CreateStandardGridViews.sql')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       155,
       'Build 5.1.1.155',
       '005 CreateStandardGridViews.sql **FAILED**')
GO

DELETE CTV
  FROM [dbo].[ControlViews] CTV
 WHERE CTV.[ControlName] = 'gBills'
   AND CTV.[OwnerName] = 'MyBills'
   AND CTV.[View] IN ('Standard View', 'Unreleased Bills', 'Approved Bills', 'All Bills', 'Unreleased Invoices')

DELETE CTQ
  FROM [dbo].[ControlQueries] CTQ
 WHERE CTQ.[ControlName] = 'gBills'
   AND CTQ.[OwnerName] = 'MyBills'
   AND CTQ.[Query] IN ('Standard View', 'Unreleased Bills', 'Approved Bills', 'All Bills', 'Unreleased Invoices')

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gBills'
      AND CTQ.[OwnerName] = 'MyBills'
      AND CTQ.[Query] = 'Draft Invoices')
BEGIN
  DELETE CTQ
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gBills'
     AND CTQ.[OwnerName] = 'MyBills'
     AND CTQ.[HANDLER] <> ''

  UPDATE CTQ
     SET CTQ.[Default] = 0
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gBills'
     AND CTQ.[OwnerName] = 'MyBills'

  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'Draft Invoices',
         'gBills',
         'MyBills',
         1,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="1"><property name="Item1" isnull="true" iskey="true"><property name="FilterText">[Released] = ''N''</property><property name="FilterString">[Released] = ''N''</property></property></property><property name="FilterString">[Released] = ''N'' And [BillNo] = 0</property><property name="IsFilterEnabled">true</property></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gBills'
      AND CTV.[OwnerName] = 'MyBills'
      AND CTV.[View] = 'Draft Invoices')
BEGIN

  DELETE CTV
    FROM [dbo].[ControlViews] CTV
   WHERE CTV.[ControlName] = 'gBills'
     AND CTV.[OwnerName] = 'MyBills'
     AND CTV.[HANDLER] <> ''

  UPDATE CTV
     SET CTV.[Default] = 0
    FROM [dbo].[ControlViews] CTV
   WHERE CTV.[ControlName] = 'gBills'
     AND CTV.[OwnerName] = 'MyBills'

  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         1,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="9">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">colMatter</property>
        <property name="FieldName">Matter</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">122.43406593406603</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colDate</property>
        <property name="FieldName">BillDate</property>
        <property name="GridRow">0</property>
        <property name="Width">95</property>
        <property name="ActualWidth">90.999999999999972</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">colAddressee</property>
        <property name="FieldName">Addressee</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">207.00000000000003</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">colAddress</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">300</property>
        <property name="ActualWidth">167</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">colBillType</property>
        <property name="FieldName">Type</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">44.736593406745619</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">colTotal</property>
        <property name="FieldName">Total</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">84.342962833273532</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">colDraftno</property>
        <property name="FieldName">DraftNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">55.486377825914893</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">colBillno</property>
        <property name="Visible">false</property>
        <property name="FieldName">BillNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">colReleased</property>
        <property name="Visible">false</property>
        <property name="FieldName">Released</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">50</property>
      </property>
    </property>
    <property name="View" isnull="true" iskey="true">
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">798,191</property>
      </property>
      <property name="ShowGroupPanel">false</property>
    </property>
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="SortInfo" iskey="true" value="0" />
    <property name="MRUFilters" iskey="true" value="1">
      <property name="Item1" isnull="true" iskey="true">
        <property name="FilterText">[Released] = ''N''</property>
        <property name="FilterString">[Released] = ''N''</property>
      </property>
    </property>
    <property name="FilterString">[Released] = ''N'' And [BillNo] = 0</property>
    <property name="IsFilterEnabled">true</property>
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gBills'
     AND CTQ.[OwnerName] = 'MyBills'
     AND CTQ.[Query] = 'Draft Invoices'

END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gBills'
      AND CTQ.[OwnerName] = 'MyBills'
      AND CTQ.[Query] = 'Released Invoices')
BEGIN
  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'Released Invoices',
         'gBills',
         'MyBills',
         0,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="0" /><property name="FilterString">[Released] = ''Y'' And [BillNo] = 0</property><property name="IsFilterEnabled">true</property></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gBills'
      AND CTV.[OwnerName] = 'MyBills'
      AND CTV.[View] = 'Released Invoices')
BEGIN

  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         0,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="9">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">colMatter</property>
        <property name="FieldName">Matter</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">122.43406593406603</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colDate</property>
        <property name="FieldName">BillDate</property>
        <property name="GridRow">0</property>
        <property name="Width">95</property>
        <property name="ActualWidth">90.999999999999972</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">colAddressee</property>
        <property name="FieldName">Addressee</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">207.00000000000003</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">colAddress</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">300</property>
        <property name="ActualWidth">167</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">colBillType</property>
        <property name="FieldName">Type</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">44.736593406745619</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">colTotal</property>
        <property name="FieldName">Total</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">84.342962833273532</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">colDraftno</property>
        <property name="FieldName">DraftNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">55.486377825914893</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">colBillno</property>
        <property name="Visible">false</property>
        <property name="FieldName">BillNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">colReleased</property>
        <property name="Visible">false</property>
        <property name="FieldName">Released</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">50</property>
      </property>
    </property>
    <property name="View" isnull="true" iskey="true">
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">798,191</property>
      </property>
      <property name="ShowGroupPanel">false</property>
    </property>
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="SortInfo" iskey="true" value="0" />
    <property name="MRUFilters" iskey="true" value="0">
    </property>
    <property name="FilterString">[Released] = ''Y'' And [BillNo] = 0</property>
    <property name="IsFilterEnabled">true</property>
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gBills'
     AND CTQ.[OwnerName] = 'MyBills'
     AND CTQ.[Query] = 'Released Invoices'

END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gBills'
      AND CTQ.[OwnerName] = 'MyBills'
      AND CTQ.[Query] = 'All Invoices')
BEGIN
  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'All Invoices',
         'gBills',
         'MyBills',
         0,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="0" /></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gBills'
      AND CTV.[OwnerName] = 'MyBills'
      AND CTV.[View] = 'All Invoices')
BEGIN
  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         0,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="9">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">colMatter</property>
        <property name="FieldName">Matter</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">105.3952380952383</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colDate</property>
        <property name="FieldName">BillDate</property>
        <property name="GridRow">0</property>
        <property name="Width">95</property>
        <property name="ActualWidth">93.999999999999972</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">colAddressee</property>
        <property name="FieldName">Addressee</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">100.6474729769208</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">colAddress</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">300</property>
        <property name="ActualWidth">156</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">colBillType</property>
        <property name="FieldName">Type</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">43.71568530460668</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">colTotal</property>
        <property name="FieldName">Total</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">76.175306106209177</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">colDraftno</property>
        <property name="FieldName">DraftNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">73.0978571793446</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">colBillno</property>
        <property name="FieldName">BillNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">52.312174028672558</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">colReleased</property>
        <property name="FieldName">Released</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">70.6562663090079</property>
      </property>
    </property>
    <property name="View" isnull="true" iskey="true">
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">585,191</property>
      </property>
      <property name="ShowGroupPanel">false</property>
    </property>
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="SortInfo" iskey="true" value="0" />
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gBills'
     AND CTQ.[OwnerName] = 'MyBills'
     AND CTQ.[Query] = 'All Invoices'

END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gBills'
      AND CTQ.[OwnerName] = 'MyBills'
      AND CTQ.[Query] = 'Approved Invoices')
BEGIN
  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'Approved Invoices',
         'gBills',
         'MyBills',
         0,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="0" /><property name="FilterString">[Released] = ''Y'' And [BillNo] &lt;&gt; 0</property><property name="IsFilterEnabled">true</property></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gBills'
      AND CTV.[OwnerName] = 'MyBills'
      AND CTV.[View] = 'Approved Invoices')
BEGIN
  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         0,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="9">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">colMatter</property>
        <property name="FieldName">Matter</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">122.43406593406603</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colDate</property>
        <property name="FieldName">BillDate</property>
        <property name="GridRow">0</property>
        <property name="Width">95</property>
        <property name="ActualWidth">90.999999999999972</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">colAddressee</property>
        <property name="FieldName">Addressee</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">207.00000000000003</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">colAddress</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">300</property>
        <property name="ActualWidth">167</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">colBillType</property>
        <property name="FieldName">Type</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">44.736593406745619</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">colTotal</property>
        <property name="FieldName">Total</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">84.342962833273532</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">colDraftno</property>
        <property name="FieldName">DraftNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">55.486377825914893</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">colBillno</property>
        <property name="Visible">false</property>
        <property name="FieldName">BillNo</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">colReleased</property>
        <property name="Visible">false</property>
        <property name="FieldName">Released</property>
        <property name="GridRow">0</property>
        <property name="Width">50</property>
        <property name="ActualWidth">50</property>
      </property>
    </property>
    <property name="View" isnull="true" iskey="true">
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">798,191</property>
      </property>
      <property name="ShowGroupPanel">false</property>
    </property>
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="SortInfo" iskey="true" value="0" />
    <property name="MRUFilters" iskey="true" value="0">
    </property>
    <property name="FilterString">[Released] = ''Y'' And [BillNo] &lt;&gt; 0</property>
    <property name="IsFilterEnabled">true</property>
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gBills'
     AND CTQ.[OwnerName] = 'MyBills'
     AND CTQ.[Query] = 'Approved Invoices'

END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTL
    WHERE CTL.[OwnerName] = 'CaseSearch'
      AND CTL.[ControlName] = 'gCases'
      AND CTL.[Query] = 'Closed Cases')
BEGIN
  DELETE CTL
    FROM [dbo].[ControlQueries] CTL
   WHERE CTL.[OwnerName] = 'CaseSearch'
     AND CTL.[ControlName] = 'gCases'
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTL
    WHERE CTL.[OwnerName] = 'CaseSearch'
      AND CTL.[ControlName] = 'gCases'
      AND CTL.[View] = 'Closed Cases')
BEGIN
  DELETE CTL
    FROM [dbo].[ControlViews] CTL
   WHERE CTL.[OwnerName] = 'CaseSearch'
     AND CTL.[ControlName] = 'gCases'
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTL
    WHERE CTL.[OwnerName] = 'CaseSearch'
      AND CTL.[ControlName] = 'gCases'
      AND CTL.[View] = 'Open Cases'
      AND CTL.[ControlSettings] LIKE '%lastaccessed%')
BEGIN
  DELETE CTL
    FROM [dbo].[ControlViews] CTL
   WHERE CTL.[OwnerName] = 'CaseSearch'
     AND CTL.[ControlName] = 'gCases'
     AND CTL.[View] IN ('Open Cases', 'Closed Cases', 'Open and Closed Cases')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gCases'
      AND CTQ.[OwnerName] = 'CaseSearch'
      AND CTQ.[Query] = 'Open Cases')
BEGIN
  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'Open Cases',
         'gCases',
         'CaseSearch',
         1,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="0" /><property name="FilterString">[Closed] &lt;&gt; ''Y''</property><property name="IsFilterEnabled">true</property></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gCases'
      AND CTV.[OwnerName] = 'CaseSearch'
      AND CTV.[View] = 'Open Cases')
BEGIN
  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         1,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="18">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">Code</property>
        <property name="FieldName">Code</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">FileColourFld</property>
        <property name="FieldName">FileColour_Fld</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">Name</property>
        <property name="FieldName">Name</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">Description</property>
        <property name="FieldName">Description</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">255</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">Fe</property>
        <property name="FieldName">Fe</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">User1</property>
        <property name="FieldName">User1</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">User2</property>
        <property name="FieldName">User2</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">User3</property>
        <property name="FieldName">User3</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">9</property>
        <property name="Name">Started</property>
        <property name="FieldName">Started</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">93</property>
      </property>
      <property name="Item10" isnull="true" iskey="true">
        <property name="VisibleIndex">10</property>
        <property name="Name">Dept</property>
        <property name="FieldName">Dept</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">113</property>
      </property>
      <property name="Item11" isnull="true" iskey="true">
        <property name="VisibleIndex">11</property>
        <property name="Name">WorkType</property>
        <property name="FieldName">WorkType</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item12" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Privileges</property>
        <property name="FieldName">Privileges</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item13" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">OldRef</property>
        <property name="Visible">false</property>
        <property name="FieldName">OldRef</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item14" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Address</property>
        <property name="Visible">false</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item15" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Closed</property>
        <property name="Visible">false</property>
        <property name="FieldName">Closed</property>
        <property name="GridRow">0</property>
        <property name="Width">70</property>
        <property name="ActualWidth">70</property>
      </property>
      <property name="Item16" isnull="true" iskey="true">
        <property name="VisibleIndex">13</property>
        <property name="Name">OrgClosedDate</property>
        <property name="FieldName">OrgClosedDate</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">150</property>
      </property>
      <property name="Item17" isnull="true" iskey="true">
        <property name="VisibleIndex">13</property>
        <property name="Name">CloseDate</property>
        <property name="Visible">false</property>
        <property name="FieldName">CloseDate</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item18" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">LastAccessed</property>
        <property name="FieldName">LastAccessed</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">150</property>
      </property>
    </property>
    <property name="SortInfo" iskey="true" value="0" />
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="View" isnull="true" iskey="true">
      <property name="ShowGroupPanel">false</property>
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">1175,207</property>
      </property>
      <property name="FormatConditions" iskey="true" value="0" />
    </property>
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="FilterString">[Closed] &lt;&gt; ''Y''</property>
    <property name="IsFilterEnabled">true</property>
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gCases'
     AND CTQ.[OwnerName] = 'CaseSearch'
     AND CTQ.[Query] = 'Open Cases'

END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gCases'
      AND CTQ.[OwnerName] = 'CaseSearch'
      AND CTQ.[Query] = 'Closed Cases')
BEGIN
  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'Closed Cases',
         'gCases',
         'CaseSearch',
         0,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="0" /><property name="FilterString">[Closed] = ''Y''</property><property name="IsFilterEnabled">true</property></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gCases'
      AND CTV.[OwnerName] = 'CaseSearch'
      AND CTV.[View] = 'Closed Cases')
BEGIN
  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         0,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="18">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">Code</property>
        <property name="FieldName">Code</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">FileColourFld</property>
        <property name="FieldName">FileColour_Fld</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">Name</property>
        <property name="FieldName">Name</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">Description</property>
        <property name="FieldName">Description</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">290</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">Fe</property>
        <property name="FieldName">Fe</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">User1</property>
        <property name="FieldName">User1</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">User2</property>
        <property name="FieldName">User2</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">User3</property>
        <property name="FieldName">User3</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">9</property>
        <property name="Name">Started</property>
        <property name="FieldName">Started</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item10" isnull="true" iskey="true">
        <property name="VisibleIndex">10</property>
        <property name="Name">Dept</property>
        <property name="FieldName">Dept</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item11" isnull="true" iskey="true">
        <property name="VisibleIndex">11</property>
        <property name="Name">WorkType</property>
        <property name="FieldName">WorkType</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item12" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Privileges</property>
        <property name="FieldName">Privileges</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item13" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">OldRef</property>
        <property name="Visible">false</property>
        <property name="FieldName">OldRef</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item14" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Address</property>
        <property name="Visible">false</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item15" isnull="true" iskey="true">
        <property name="VisibleIndex">13</property>
        <property name="Name">Closed</property>
        <property name="Visible">false</property>
        <property name="FieldName">Closed</property>
        <property name="GridRow">0</property>
        <property name="Width">70</property>
        <property name="ActualWidth">70</property>
      </property>
      <property name="Item16" isnull="true" iskey="true">
        <property name="VisibleIndex">13</property>
        <property name="Name">OrgClosedDate</property>
        <property name="Visible">false</property>
        <property name="FieldName">OrgClosedDate</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">150</property>
      </property>
      <property name="Item17" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">CloseDate</property>
        <property name="FieldName">CloseDate</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item18" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">LastAccessed</property>
        <property name="Visible">false</property>
        <property name="FieldName">LastAccessed</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">150</property>
      </property>
    </property>
    <property name="SortInfo" iskey="true" value="0" />
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="View" isnull="true" iskey="true">
      <property name="ShowGroupPanel">false</property>
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">1175,207</property>
      </property>
      <property name="FormatConditions" iskey="true" value="0" />
    </property>
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="FilterString">[Closed] = ''Y''</property>
    <property name="IsFilterEnabled">true</property>
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gCases'
     AND CTQ.[OwnerName] = 'CaseSearch'
     AND CTQ.[Query] = 'Closed Cases'

END
GO


IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlQueries] CTQ
    WHERE CTQ.[ControlName] = 'gCases'
      AND CTQ.[OwnerName] = 'CaseSearch'
      AND CTQ.[Query] = 'Open and Closed Cases')
BEGIN
  INSERT
    INTO [dbo].[ControlQueries]
        ([HANDLER],
         [Query],
         [ControlName],
         [OwnerName],
         [Default],
         [ControlSettings])
  VALUES('',
         'Open and Closed Cases',
         'gCases',
         'CaseSearch',
         0,
         '<XtraSerializer><property name="$GridControl"><property name="MRUFilters" iskey="true" value="0" /></property></XtraSerializer>')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[ControlViews] CTV
    WHERE CTV.[ControlName] = 'gCases'
      AND CTV.[OwnerName] = 'CaseSearch'
      AND CTV.[View] = 'Open and Closed Cases')
BEGIN
  INSERT
    INTO [dbo].[ControlViews]
        ([HANDLER],
         [View],
         [ControlName],
         [OwnerName],
         [Default],
         [QueryID],
         [ControlSettings])
  SELECT CTQ.[HANDLER],
         CTQ.[Query],
         CTQ.[ControlName],
         CTQ.[OwnerName],
         0,
         CTQ.[id],
         '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="18">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">Code</property>
        <property name="FieldName">Code</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">FileColourFld</property>
        <property name="FieldName">FileColour_Fld</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">Name</property>
        <property name="FieldName">Name</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">Description</property>
        <property name="FieldName">Description</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">Fe</property>
        <property name="FieldName">Fe</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">User1</property>
        <property name="FieldName">User1</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">User2</property>
        <property name="FieldName">User2</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">User3</property>
        <property name="FieldName">User3</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">9</property>
        <property name="Name">Started</property>
        <property name="FieldName">Started</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item10" isnull="true" iskey="true">
        <property name="VisibleIndex">10</property>
        <property name="Name">Dept</property>
        <property name="FieldName">Dept</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item11" isnull="true" iskey="true">
        <property name="VisibleIndex">11</property>
        <property name="Name">WorkType</property>
        <property name="FieldName">WorkType</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item12" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Privileges</property>
        <property name="FieldName">Privileges</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item13" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">OldRef</property>
        <property name="Visible">false</property>
        <property name="FieldName">OldRef</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item14" isnull="true" iskey="true">
        <property name="VisibleIndex">12</property>
        <property name="Name">Address</property>
        <property name="Visible">false</property>
        <property name="FieldName">Address</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item15" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">Closed</property>
        <property name="FieldName">Closed</property>
        <property name="GridRow">0</property>
        <property name="Width">70</property>
        <property name="ActualWidth">70</property>
      </property>
      <property name="Item16" isnull="true" iskey="true">
        <property name="VisibleIndex">13</property>
        <property name="Name">OrgClosedDate</property>
        <property name="FieldName">OrgClosedDate</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">150</property>
      </property>
      <property name="Item17" isnull="true" iskey="true">
        <property name="VisibleIndex">14</property>
        <property name="Name">CloseDate</property>
        <property name="FieldName">CloseDate</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item18" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">LastAccessed</property>
        <property name="Visible">false</property>
        <property name="FieldName">LastAccessed</property>
        <property name="GridRow">0</property>
        <property name="Width">150</property>
        <property name="ActualWidth">150</property>
      </property>
    </property>
    <property name="SortInfo" iskey="true" value="0" />
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="View" isnull="true" iskey="true">
      <property name="ShowGroupPanel">false</property>
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">1175,207</property>
      </property>
      <property name="FormatConditions" iskey="true" value="0" />
    </property>
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>'
    FROM [dbo].[ControlQueries] CTQ
   WHERE CTQ.[ControlName] = 'gCases'
     AND CTQ.[OwnerName] = 'CaseSearch'
     AND CTQ.[Query] = 'Open and Closed Cases'

END
GO

UPDATE SKL
   SET SKL.[COMMENT] = '005 CreateStandardGridViews.sql' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 155
   AND SKL.[COMMENT] = '005 CreateStandardGridViews.sql **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO